<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Standard\Types;

use Swoox\Api\Api\Manager as ApiManager;

class Factory
{

    /**
     *
     * @var array
     */
    protected $facSetter;


    /**
     * @var ApiManager
     */
    protected $apiM;


    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }


    /**
     *
     * @return DateTime
     */
    public function dateTime()
    {

        return new DateTime($this->apiM);
    }


    /**
     *
     * @return Fallback
     */
    public function fallback()
    {

        return new Fallback($this->apiM);
    }


    /**
     *
     * @return GeoPoint
     */
    public function geoPoint()
    {

        return new GeoPoint($this->apiM);
    }


    /**
     *
     * @return GeoShape
     */
    public function geoShape()
    {

        return new GeoShape($this->apiM);
    }


    /**
     *
     * @return MultiSelect
     */
    public function multiSelect()
    {

        return new MultiSelect($this->apiM);
    }


    /**
     *
     * @return MultiValue
     */
    public function multiValue()
    {

        return new MultiValue($this->apiM);
    }


    /**
     *
     * @return Range
     */
    public function range()
    {

        return new Range($this->apiM);
    }


    /**
     *
     * @return Value
     */
    public function value()
    {

        return new Value($this->apiM);
    }


    /**
     *
     * @return Error
     */
    public function error()
    {

        return new Error($this->apiM);
    }


    /**
     *
     * @return Defaults
     */
    public function defaults()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Defaults($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }
}
