<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Standard\Types;

use Swoox\Api\Model\Request\Search\Interfaces\TypeInterface;
use Swoox\ClientBundle\Entity\ProSlots;

class MultiSelect implements TypeInterface
{
    use \Swoox\Api\Model\Request\Search\Traits\Type;

    /**
     * @param $value
     *
     * @return self
     */
    public function setFromQuery($value, $key = null)
    {

        if (is_array($value)) {
            $value = array_values($value);  // clean up arrays keys, making sure it's only numericals starting at "0"
        } else {
            $value[0] = $value;  // didn't get an array? Let's make one out of the one value we got
        }

        $this->value = $value;

        return $this;
    }
}
