<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Traits;

trait RequestDefaults
{

    /**
     * @var array
     */
    protected $allowedValues;
    /**
     * @var integer
     */
    protected $clientid;
    /**
     * @var string
     */
    protected $filterset;
    /**
     * @var string
     */
    protected $keywords;
    /**
     * @var integer
     */
    protected $limit;
    /**
     * @var integer
     */
    protected $offset;
    /**
     * @var string
     */
    protected $search;
    /**
     * @var string
     */
    protected $searchorder;
    /**
     * @var  string
     */
    protected $searchordertwo;
    /**
     * @var string
     */
    protected $sid;
    /**
     * @var string
     */
    protected $statistics;
    /**
     * @var integer
     */
    protected $tpl;
    /**
     * @var string
     */
    protected $trigger;
    /**
     * @var string
     */
    protected $xfilterset;

    public function __construct()
    {

        $this->allowedValues = $this->getSetMethodNames();
    }


    /**
     * Returns the names (without the "set" prefix) of all available (public) setter methods
     *
     * @return array
     */
    protected function getSetMethodNames()
    {

        $reflectionClass = new \ReflectionClass(__CLASS__);
        $setMethods = array();
        foreach ($reflectionClass->getMethods(\ReflectionMethod::IS_PUBLIC) as $reflectionMethod) {
            preg_match("/(set+[A-Z]+[a-z])/", $reflectionMethod->name, $match);
            if ($match) {
                //better was to get rid of the first set
                $name = substr($reflectionMethod->name, 3);
                $setMethods[$name] = $name;
            }
        }

        return $setMethods;
    }


    /**
     * @return array
     */
    public function getAllowedValues()
    {

        return $this->allowedValues;
    }

    /**
     * @return int
     */
    public function getClientid()
    {

        return $this->clientid;
    }

    /**
     * @param int $clientid
     */
    public function setClientid($clientid)
    {

        $this->clientid = $clientid;

        return $this;
    }

    /**
     * @return string
     */
    public function getFilterset()
    {

        return $this->filterset;
    }

    /**
     * @param string $filterset
     */
    public function setFilterset($filterset)
    {

        $this->filterset = $filterset;

        return $this;
    }

    /**
     * @return string
     */
    public function getKeywords()
    {

        return $this->keywords;
    }

    /**
     * @param string $keywords
     */
    public function setKeywords($keywords)
    {

        $this->keywords = $keywords;

        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {

        return $this->limit;
    }

    /**
     * @param int $limit
     */
    public function setLimit($limit)
    {

        $this->limit = $limit;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {

        return $this->offset;
    }

    /**
     * @param int $offset
     */
    public function setOffset($offset)
    {

        $this->offset = $offset;

        return $this;
    }

    /**
     * @return string
     */
    public function getSearch()
    {

        return $this->search;
    }

    /**
     * @param string $search
     */
    public function setSearch($search)
    {

        $this->search = $search;

        return $this;
    }

    /**
     * @return string
     */
    public function getSearchorder()
    {

        return $this->searchorder;
    }

    /**
     * @param string $searchorder
     */
    public function setSearchorder($searchorder)
    {

        if ('0;0' != $searchorder) {
            $this->searchorder = $searchorder;
        }


        return $this;
    }

    /**
     * @return string
     */
    public function getSearchordertwo()
    {

        return $this->searchordertwo;
    }

    /**
     * @param string $searchordertwo
     */
    public function setSearchordertwo($searchordertwo)
    {

        if ('0;0' != $searchordertwo) {
            $this->searchordertwo = $searchordertwo;
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getSid()
    {

        return $this->sid;
    }

    /**
     * @param string $sid
     */
    public function setSid($sid)
    {

        $this->sid = $sid;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatistics()
    {

        return $this->statistics;
    }

    /**
     * @param string $statistics
     */
    public function setStatistics($statistics)
    {

        $this->statistics = $statistics;

        return $this;
    }

    /**
     * @return int
     */
    public function getTpl()
    {

        return $this->tpl;
    }

    /**
     * @param int $tpl
     */
    public function setTpl($tpl)
    {

        $this->tpl = $tpl;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrigger()
    {

        return $this->trigger;
    }

    /**
     * @param string $trigger
     */
    public function setTrigger($trigger)
    {

        $this->trigger = $trigger;

        return $this;
    }

    /**
     * @return string
     */
    public function getXfilterset()
    {

        return $this->xfilterset;
    }

    /**
     * @param string $xfilterset
     *
     * @return RequestDefaults
     */
    public function setXfilterset($xfilterset)
    {

        $this->xfilterset = $xfilterset;

        return $this;
    }
}
