<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

/**
 * Created by PhpStorm.
 * User: minduser
 * Date: 30/03/16
 * Time: 11:18
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Item
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 * @Serializer\XmlRoot("Distance")
 */
class Distance
{
    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $docCount;
    /**
     * @Serializer\SerializedName("From")
     * @Serializer\Type("double")
     *
     * @var string
     */
    private $from;

    /**
     * @Serializer\SerializedName("FromAsString")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $fromAsString;
    /**
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $key;
    /**
     * @Serializer\SerializedName("To")
     * @Serializer\Type("double")
     *
     * @var string
     */
    private $to;
    /**
     * @Serializer\SerializedName("ToAsString")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $toAsString;

    /**
     * @return int
     */
    public function getDocCount()
    {

        return $this->docCount;
    }

    /**
     * @param int $docCount
     *
     * @return Distance
     */
    public function setDocCount($docCount)
    {

        $this->docCount = $docCount;

        return $this;
    }

    /**
     * @return string
     */
    public function getFrom()
    {

        return $this->from;
    }

    /**
     * @param string $from
     *
     * @return Distance
     */
    public function setFrom($from)
    {

        $this->from = $from;

        return $this;
    }

    /**
     * @return string
     */
    public function getFromAsString()
    {

        return $this->fromAsString;
    }

    /**
     * @param string $fromAsString
     *
     * @return Distance
     */
    public function setFromAsString($fromAsString)
    {

        $this->fromAsString = $fromAsString;

        return $this;
    }

    /**
     * @return string
     */
    public function getKey()
    {

        return $this->key;
    }

    /**
     * @param string $key
     *
     * @return Distance
     */
    public function setKey($key)
    {

        $this->key = $key;

        return $this;
    }

    /**
     * @return string
     */
    public function getTo()
    {

        return $this->to;
    }

    /**
     * @param string $to
     *
     * @return Distance
     */
    public function setTo($to)
    {

        $this->to = $to;

        return $this;
    }

    /**
     * @return string
     */
    public function getToAsString()
    {

        return $this->toAsString;
    }

    /**
     * @param string $toAsString
     *
     * @return Distance
     */
    public function setToAsString($toAsString)
    {

        $this->toAsString = $toAsString;

        return $this;
    }
}
