<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Interfaces;

/**
 * Interface FilterResponseModelInterface
 *
 * @package Swoox\Api\Model\Response\Search\Interfaces
 */
interface FilterResponseModelInterface
{

    /**
     * @return FilterRangeArray
     */
    public function getFilterDistanceArray();

    /**
     * @return FilterHiddenArray
     */
    public function getFilterHiddenArray();

    /**
     * @return FilterMultiSelectArray
     */
    public function getFilterMultiSelectArray();

    /**
     * @return FilterRangeArray
     */
    public function getFilterRangeArray();

    /**
     * @return FilterValueArray
     */
    public function getFilterValueArray();

    /**
     * @param FilterRangeArray $filterDistanceArray
     *
     * @return FilterResponse
     */
    public function setFilterDistanceArray($filterDistanceArray);

    /**
     * @param FilterHiddenArray $filterHiddenArray
     *
     * @return FilterResponse
     */
    public function setFilterHiddenArray($filterHiddenArray);

    /**
     * @param FilterMultiSelectArray $filterMultiSelectArray
     *
     * @return FilterResponse
     */
    public function setFilterMultiSelectArray($filterMultiSelectArray);

    /**
     * @param FilterRangeArray $filterRangeArray
     *
     * @return FilterResponse
     */
    public function setFilterRangeArray($filterRangeArray);

    /**
     * @param FilterValueArray $filterValueArray
     *
     * @return FilterResponse
     */
    public function setFilterValueArray($filterValueArray);
}
