<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Standard;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("Sort")
 */
class Sort
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $value;

    /**
     * @return string
     */
    public function getValue()
    {

        return $this->value;
    }

    /**
     * @param string $value
     *
     * @return Sort
     */
    public function setValue($value)
    {

        $this->value = (string) $value;

        return $this;
    }
}
