<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Recommendation;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Recommendation\Request;

/**
 * Class RequestTest
 *
 * @package Tests\Swoox\Api\Model\Request\Recommendation
 */
class RequestTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var ApiManager
     */
    private $apiManager;
    /**
     * @var \JMS\Serializer\Serializer
     */
    private $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->apiManager = new ApiManager();
        $this->apiManager->validator();
        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $this->markTestIncomplete(
            'check validator!'
        );

        $request = new Request();

        $request->setId(2);
        $request->setKeyword('keyword');
        $request->setWeight(80);

        echo $this->serializer->serialize($request, 'json');
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        $this->markTestIncomplete(
            'check validator!'
        );
    }
}
