<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Rules;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Response\Rules\Response;

/**
 * Class ResponseTest
 *
 * @package Tests\Swoox\Api\Model\Request\Rules
 */
class ResponseTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var \JMS\Serializer\Serializer
     */
    private $serializer;

    /**
     * @var Response
     */
    private $response;

    /**
     * @var string
     */
    private $serializedData;

    /**
     * setUp
     */
    public function setUp()
    {
        $this->apiManager = new ApiManager();
        $this->apiManager->validator();
        $this->serializer = SerializerBuilder::create()->build();
        $this->serializedData = file_get_contents('Tests/data/Swoox/Api/Model/Response/Rules/testData.xml', true);
        $this->response = new Response();
        $this->response->setRuleName('TestRule');
        $this->response->setClientId(1);
        $this->response->setError('No Error');
        $this->response->setStatusCode(200);
        $this->response->setResults(['articleId' => 'ABC', 'clientId' => 1]);
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {
        $serialized = preg_replace('/\s+/', '', $this->serializer->serialize($this->response, 'xml'));
        $this->assertEquals(preg_replace('/\s+/', '', $this->serializedData), $serialized);
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {
        /** @var Response $response */
        $response = $this->serializer->deserialize($this->serializedData, 'Swoox\Api\Model\Response\Rules\Response', 'xml');
        $this->assertEquals($this->response->getClientId(), $response->getClientId());
        $this->assertEquals($this->response->getResults(), $response->getResults());
        $this->assertEquals($this->response->getRuleName(), $response->getRuleName());
        $this->assertEquals($this->response->getStatusCode(), $response->getStatusCode());
        $this->assertEquals($this->response->getError(), $response->getError());
        $this->assertEquals($this->response, $response);
    }
}
