<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Standard\Types;

use Swoox\Api\Model\Request\Search\Interfaces\TypeInterface;
use Swoox\ClientBundle\Entity\ProSlots;


class Range implements TypeInterface
{

    use \Swoox\Api\Model\Request\Search\Traits\Type;

    /**
     * @param $value
     *
     * @return self
     */
    public function setFromQuery($value, $key = null)
    {

        if (is_array($value)) {
            $min = (double) min($value);
            $max = (double) max($value);
            if (!empty($min) && !empty($min)) {
                $value = [$min, $max];
            } else {
                throw new \Exception('No values min and max set');
            }

        } else {
            // didn't get an array? That's like foo without a bar....
            throw new \Exception('No array as range given');
        }

        $this->value = $value;

        return $this;
    }

}
