<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Interfaces;


/**
 * Interface FilterTypeInterface
 *
 * @package Swoox\Api\Model\Response\Search\Interfaces
 */
interface FilterTypeInterface
{

    /**
     * @return DistanceArray
     */
    public function getDistanceArray();

    /**
     * @return string
     */
    public function getDistanceSelection();

    /**
     * @return float
     */
    public function getMaxValue();

    /**
     * @return float
     */
    public function getMinValue();

    /**
     * @return string
     */
    public function getName();

    /**
     * @return string
     */
    public function getOrder();

    /**
     * @return int
     */
    public function getSlot();

    /**
     * @return string
     */
    public function getSlotClean();

    /**
     * @return string
     */
    public function getValue();

    /**
     * @return ValueArray
     */
    public function getValueArray();

    /**
     * @param DistanceArray $distanceArray
     *
     * @return Filter
     */
    public function setDistanceArray($distanceArray);

    /**
     * @param string $distanceSelection
     *
     * @return Filter
     */
    public function setDistanceSelection($distanceSelection);

    /**
     * @param float $maxValue
     *
     * @return Filter
     */
    public function setMaxValue($maxValue);

    /**
     * @param float $minValue
     *
     * @return Filter
     */
    public function setMinValue($minValue);

    /**
     * @param string $name
     *
     * @return Filter
     */
    public function setName($name);

    /**
     * @param string $order
     *
     * @return Filter
     */
    public function setOrder($order);

    /**
     * @param int $slot
     *
     * @return Filter
     */
    public function setSlot($slot);

    /**
     * @param string $slotClean
     *
     * @return Filter
     */
    public function setSlotClean($slotClean);

    /**
     * @param string $value
     *
     * @return Filter
     */
    public function setValue($value);

    /**
     * @param ValueArray $valueArray
     *
     * @return Filter
     */
    public function setValueArray($valueArray);
}
