<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Suggested;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ValueArray
 *
 * @package Swoox\Api\Model\Response\Search\Suggested
 *
 * @Serializer\XmlRoot("ValueArray")
 */
class ValueArray
{

    /**
     * @Serializer\Type("ArrayCollection<Swoox\Api\Model\Response\Search\Suggested\FilterItem>")
     * @Serializer\XmlList(inline=true, entry="Item")
     *
     * @var FilterItem[]
     */
    protected $items;
    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(inline=true, entry="Value")
     *
     * @var string[]
     */
    protected $values;

    public function __construct()
    {

        $this->values = new ArrayCollection();
        $this->items = new ArrayCollection();
    }

    /**
     * @param FilterItem $item
     *
     * @return ValueArray
     */
    public function addItem(FilterItem $item)
    {

        if (!$this->items->contains($item)) {
            $this->items->add($item);
        }

        return $this;
    }

    /**
     * @param string $value
     *
     * @return ValueArray
     */
    public function addValue($value)
    {

        if (!$this->values->contains($value)) {
            $this->values->add($value);
        }

        return $this;
    }

    /**
     * @return mixed
     */
    public function getItems()
    {

        return $this->items;
    }

    /**
     * @return string[]
     */
    public function getValues()
    {

        return $this->values;
    }
}
