<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      René Stetter
 * @copyright   2017 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Swoox\Api\Repository;

/**
 * Interface RepositoryInterface
 *
 * @package Swoox\Api\Repository
 */
interface RepositoryInterface
{
    /**
     * Implement this method to find an entity by custom swoox id
     *
     * @param $swooxId
     *
     * @return null|object
     */
    public function findBySwooxId($swooxId);

    /**
     * @param \DateTime $lastChanged
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function findByDateLastChanged(\DateTime $lastChanged);
}
