<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Delete\Swoox;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Model\Request\Delete\Swoox\Item;
use Swoox\Api\Model\Request\Delete\Swoox\Request;

class RequestTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     *
     */
    public function setUp(): void
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     *
     */
    public function testSerialize()
    {

        $jsonString = '{"UserData":{"ApiVersion":"1","AuthToken":"","ErrorLanguage":"en","ProjectId":"42","RefererURL":""},"ItemsArray":[{"DocumentUniqueKey":"xyz"}]}';

        $request = new Request();

        $item = new Item();
        $item->setDocumentUniqueKey('xyz');

        $request->addItem($item);

        $json = $this->serializer->serialize($request, 'json');

        $this->assertEquals($jsonString, $json);
    }

    /**
     *
     */
    public function testDeserialize()
    {

        $xml = file_get_contents('Tests/data/Swoox/Api/Model/Request/Delete/Swoox/request.xml', true);

        /**
         * @var \Swoox\Api\Model\Request\Delete\Swoox\Request $request
         */
        $request = $this->serializer->deserialize($xml, 'Swoox\Api\Model\Request\Delete\Swoox\Request', 'xml');

        $this->assertInstanceOf('Swoox\Api\Model\Request\Delete\Swoox\Request', $request);


        $userData = $request->getUserData();

        $this->assertEquals('1', $userData->getApiVersion());
        $this->assertEquals('', $userData->getAuthToken());
        $this->assertEquals('en', $userData->getErrorLanguage());
        $this->assertEquals('42', $userData->getProjectId());
        $this->assertEquals('', $userData->getRefererURL());


        $items = $request->getItems();

        $this->assertInstanceOf('Swoox\Api\Model\Request\Delete\Swoox\Item', $items[0]);
        $this->assertEquals('xyz', $items[0]->getDocumentUniqueKey());
    }
}
