<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Search\Filter\Types;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Search\Filter\Types\Error;

class ErrorTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var Error
     */
    private $error;

    public function setUp(): void
    {

        $this->error = new Error(new ApiManager());
    }

    public function testMessage()
    {

        $testString = 'test string';
        $this->error->setMessage($testString);
        $this->assertEquals($testString, $this->error->getMessage());
    }

    public function testSetFromQuery()
    {

        $this->error->setFromQuery('some value');
        $this->assertEquals('some value', $this->error->getValue());
    }

    public function testSetFromQueryArray()
    {

        $this->error->setFromQuery(['some', 'value']);
        $this->assertEquals('some;value', $this->error->getValue());
    }
}
