<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Search\Filter\Types;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Search\Filter\Types\Fallback;

/**
 * Class FallbackTest
 *
 * @package Tests\Swoox\Api\Model\Request\Search\Filter\Types
 */
class FallbackTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var Fallback
     */
    private $fallback;

    /**
     * setUp
     */
    public function setUp(): void
    {

        $this->fallback = new Fallback(new ApiManager());
    }

    /**
     * testSetFromQuery
     */
    public function testSetFromQuery()
    {

        $this->fallback->setFromQuery('some value');

        $this->assertEquals('some value', $this->fallback->getValue());
    }

    /**
     * testGetKey
     */
    public function testGetKey()
    {

        $this->fallback->setFromQuery('some value', 'randomKey');

        $this->assertEquals('randomKey', $this->fallback->getKey());
    }
}
