<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Interfaces;

use Swoox\Api\Model\Request\Search\Filter\Types;

interface TypeInterface
{

    /**
     * @return \Swoox\ClientBundle\Entity\ProSlots
     */
    public function getSlotConfig();

    /**
     * @return string
     */
    public function getType();

    /**
     * @return string
     */
    public function getValue();

    /**
     * @param mixed      $value
     * @param null|mixed $key
     *
     * @return self
     */
    public function setFromQuery($value, $key = null);

    /**
     * @param \Swoox\ClientBundle\Entity\ProSlots $slotConfig
     *
     * @return self
     */
    public function setSlotConfiguration(\Swoox\ClientBundle\Entity\ProSlots $slotConfig);
}
