<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Standard;

use Doctrine\Common\Collections\ArrayCollection;
use Swoox\Api\Model\Request\Search\Interfaces\RequestModelInterface;
use Swoox\Api\Model\Request\Search\Interfaces\TypeInterface;
use Swoox\Api\Model\Request\Search\Interfaces\DefaultsInterface;

class Request implements RequestModelInterface
{

    /**
     * @var Types\Datetime[]
     */
    protected $datetime;

    /**
     * @var Types\Fallback[]
     */
    protected $fallback;

    /**
     * @var Types\Geopoint[]
     */
    protected $geopoint;

    /**
     * @var Types\Geoshape[]
     */
    protected $geoshape;

    /**
     * @var Types\Multiselect[]
     */
    protected $multiselect;

    /**
     * @var Types\Multivalue[]
     */
    protected $multivalue;

    /**
     * @var Types\Range[]
     */
    protected $range;

    /**
     * @var Types\Value[]
     */
    protected $value;

    /**
     * @var Types\Error[]
     */
    protected $error;

    /**
     * @var Types\Defaults
     */
    protected $defaults;


    public function __construct()
    {

        $this->datetime = new ArrayCollection();
        $this->fallback = new ArrayCollection();
        $this->geopoint = new ArrayCollection();
        $this->geoshape = new ArrayCollection();
        $this->multiselect = new ArrayCollection();
        $this->multivalue = new ArrayCollection();
        $this->range = new ArrayCollection();
        $this->value = new ArrayCollection();
        $this->error = new ArrayCollection();
        $this->defaults = null;
    }


    /*
     *    ----------***   SETTER   ***----------
     */

    /**
     * @param TypeInterface $datetime
     */
    public function addDateTime(TypeInterface $datetime)
    {

        if (!$this->datetime->contains($datetime)) {
            $this->datetime->add($datetime);
        }
    }

    /**
     * @param TypeInterface $fallback
     */
    public function addFallback(TypeInterface $fallback)
    {

        if (!$this->fallback->contains($fallback)) {
            $this->fallback->add($fallback);
        }
    }

    /**
     * @param TypeInterface $geopoint
     */
    public function addGeoPoint(TypeInterface $geopoint)
    {

        if (!$this->geopoint->contains($geopoint)) {
            $this->geopoint->add($geopoint);
        }
    }

    /**
     * @param TypeInterface $geoshape
     */
    public function addGeoShape(TypeInterface $geoshape)
    {

        if (!$this->geoshape->contains($geoshape)) {
            $this->geoshape->add($geoshape);
        }
    }

    /**
     * @param TypeInterface $multiselect
     */
    public function addMultiSelect(TypeInterface $multiselect)
    {

        if (!$this->multiselect->contains($multiselect)) {
            $this->multiselect->add($multiselect);
        }
    }

    /**
     * @param TypeInterface $multivalue
     */
    public function addMultiValue(TypeInterface $multivalue)
    {

        if (!$this->multivalue->contains($multivalue)) {
            $this->multivalue->add($multivalue);
        }
    }

    /**
     * @param TypeInterface $range
     */
    public function addRange(TypeInterface $range)
    {

        if (!$this->range->contains($range)) {
            $this->range->add($range);
        }
    }

    /**
     * @param TypeInterface $value
     */
    public function addValue(TypeInterface $value)
    {

        if (!$this->value->contains($value)) {
            $this->value->add($value);
        }
    }

    /**
     * @param TypeInterface $value
     */
    public function addError(TypeInterface $value)
    {

        if (!$this->error->contains($value)) {
            $this->error->add($value);
        }
    }

    /**
     * @param DefaultsInterface $defaults
     */
    public function setDefaults(DefaultsInterface $defaults)
    {

        $this->defaults = $defaults;
    }


    /*
     *    ----------***   GETTER   ***----------
     */

    /**
     * @return TypeInterface[]
     */
    public function getDateTimes()
    {

        return $this->datetime;
    }

    /**
     * @return TypeInterface[]
     */
    public function getFallbacks()
    {

        return $this->fallback;
    }

    /**
     * @return TypeInterface[]
     */
    public function getGeoPoints()
    {

        return $this->geopoint;
    }

    /**
     * @return TypeInterface[]
     */
    public function getGeoShapes()
    {

        return $this->geoshape;
    }

    /**
     * @return TypeInterface[]
     */
    public function getMultiSelects()
    {

        return $this->multiselect;
    }

    /**
     * @return TypeInterface[]
     */
    public function getMultiValues()
    {

        return $this->multivalue;
    }

    /**
     * @return TypeInterface[]
     */
    public function getRanges()
    {

        return $this->range;
    }

    /**
     * @return TypeInterface[]
     */
    public function getValues()
    {

        return $this->value;
    }

    /**
     * @return DefaultsInterface
     */
    public function getDefaults()
    {

        return $this->defaults;
    }
}
