<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Factory
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 */
class Factory
{

    /**
     * @return FilterResponse
     */
    public function response()
    {

        return new FilterResponse();
    }


    /**
     * @return Filter
     */
    public function filter()
    {

        return new Filter();
    }


    /**
     * @return FilterRangeArray
     */
    public function filterRangeArray()
    {

        return new FilterRangeArray();
    }


    /**
     * @return SelectedFilterArray
     */
    public function selectedFilterArray()
    {

        return new SelectedFilterArray();
    }


    /**
     * @return ValueArray
     */
    public function valueArray()
    {

        return new ValueArray();
    }


    /**
     * @return FilterMultiSelectArray
     */
    public function multiSelectArray()
    {

        return new FilterMultiSelectArray();
    }


    /**
     * @return FilterValueArray
     */
    public function filterValueArray()
    {

        return new FilterValueArray();
    }


    /**
     * @return FilterHiddenArray
     */
    public function filterHiddenArray()
    {

        return new FilterHiddenArray();
    }

    /**
     * @return FilterDistanceArray
     */
    public function filterDistanceArray()
    {

        return new FilterDistanceArray();
    }

    /**
     * @return Item
     */
    public function item()
    {

        return new Item();
    }

    /**
     * @return FilterSelected
     */
    public function filterSelected()
    {

        return new FilterSelected();
    }

    /**
     * @return DistanceArray
     */
    public function distanceArray()
    {

        return new DistanceArray();
    }

    /**
     * @return Distance
     */
    public function distance()
    {

        return new Distance();
    }
}
