<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Filter
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 *
 * @Serializer\XmlRoot("Selected")
 */
class FilterSelected
{

    /**
     * @Serializer\SerializedName("MaxValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $maxValue;
    /**
     * @Serializer\SerializedName("MinValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $minValue;

    /**
     * @return string
     */
    public function getMaxValue()
    {

        return $this->maxValue;
    }

    /**
     * @param string $maxValue
     *
     * @return FilterSelected
     */
    public function setMaxValue($maxValue)
    {

        $this->maxValue = $maxValue;

        return $this;
    }

    /**
     * @return string
     */
    public function getMinValue()
    {

        return $this->minValue;
    }

    /**
     * @param string $minValue
     *
     * @return FilterSelected
     */
    public function setMinValue($minValue)
    {

        $this->minValue = $minValue;

        return $this;
    }
}
