<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Suggested;

use JMS\Serializer\Annotation as Serializer;
use Swoox\Api\Model\Request\Index\Swoox\ValueItem;

/**
 * Class NameFieldList
 *
 * @package Swoox\Api\Model\Request\Index\Swoox
 *
 * @Serializer\XmlRoot("NameFieldList")
 */
class NameFieldList
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Meta")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $meta;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $name;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $value;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ValueClean")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $valueClean;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Values")
     * @Serializer\Type("array<Swoox\Api\Model\Request\Index\Swoox\ValueItem>")
     * @Serializer\XmlList(entry="ValueItem")
     *
     * @var \Swoox\Api\Model\Request\Index\Swoox\ValueItem[]
     */
    protected $values = [];

    /**
     * @return string
     */
    public function getMeta()
    {

        return $this->meta;
    }

    /**
     * @return string
     */
    public function getName()
    {

        return $this->name;
    }

    /**
     * @return string
     */
    public function getValue()
    {

        return $this->value;
    }

    /**
     * @return string
     */
    public function getValueClean()
    {

        return $this->valueClean;
    }

    /**
     * @return ValueItem[]
     */
    public function getValues()
    {

        return $this->values;
    }
}
