<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Suggested;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SearchRecommendation
 *
 * @package Swoox\Api\Model\Response\Search\Suggested
 *
 * @Serializer\XmlRoot("FilterValueArray")
 */
class SearchRecommendation
{

    /**
     * @Serializer\SerializedName("AdditionalKeywords")
     * @Serializer\Type("array<string>")
     *
     * @var String[]
     */
    protected $additionalKeyword;
    /**
     * @Serializer\SerializedName("FilterValueArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Suggested\FilterValueArray")
     *
     * @var FilterValueArray
     */
    protected $filterValueArray;
    /**
     * @Serializer\SerializedName("Keyword")
     * @Serializer\Type("string")
     *
     * @var double
     */
    protected $keyword;

    /**
     * SearchRecommendation constructor.
     */
    public function __construct()
    {
    }

    /**
     * @return \String[]
     */
    public function getAdditionalKeyword()
    {

        return $this->additionalKeyword;
    }

    /**
     * @param \String[] $additionalKeyword
     *
     * @return SearchRecommendation
     */
    public function setAdditionalKeyword($additionalKeyword)
    {

        $this->additionalKeyword = $additionalKeyword;

        return $this;
    }

    /**
     * @return FilterValueArray
     */
    public function getFilterValueArray()
    {

        return $this->filterValueArray;
    }

    /**
     * @param FilterValueArray $filterValueArray
     *
     * @return SearchResponse
     */
    public function setFilterValueArray($filterValueArray)
    {

        $this->filterValueArray = $filterValueArray;

        return $this;
    }

    /**
     * @return float
     */
    public function getKeyword()
    {

        return $this->keyword;
    }

    /**
     * @param float $keyword
     *
     * @return SearchRecommendation
     */
    public function setKeyword($keyword)
    {

        $this->keyword = $keyword;

        return $this;
    }
}
