<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Model\Request\Index\Swoox\ValueItem;

class ValueItemTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testSerialize()
    {

        $jsonString = '{"Meta":"meta","Value":"one","ValueClean":"clean one"}';

        $valueItem = new ValueItem();
        $valueItem->setMeta('meta');
        $valueItem->setValue('one');
        $valueItem->setValueClean('clean one');


        $this->assertEquals($jsonString, $this->serializer->serialize($valueItem, 'json'));
    }

    public function testDeserialize()
    {

        $xml = file_get_contents('Tests/data/Swoox/Api/Model/Request/Index/Swoox/valueitem.xml', true);

        /**
         * @var \Swoox\Api\Model\Request\Index\Swoox\ValueItem $valueItem
         */
        $valueItem = $this->serializer->deserialize($xml, 'Swoox\Api\Model\Request\Index\Swoox\ValueItem', 'xml');

        $this->assertInstanceOf('\Swoox\Api\Model\Request\Index\Swoox\ValueItem', $valueItem);

        $this->assertEquals('meta', $valueItem->getMeta());
        $this->assertEquals('one', $valueItem->getValue());
        $this->assertEquals('clean one', $valueItem->getValueClean());
    }
}
