<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ValueItem
 *
 * @package Swoox\Api\Model\Request\Index\Swoox
 *
 * @Serializer\XmlRoot("ValueItem")
 */
class ValueItem
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Meta")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $meta;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $value;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ValueClean")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $valueClean;

    /**
     * @return string
     */
    public function getMeta()
    {

        return $this->meta;
    }

    /**
     * @param string $meta
     *
     * @return ValueItem
     */
    public function setMeta($meta)
    {

        $this->meta = $meta;

        return $this;
    }

    /**
     * @return string
     */
    public function getValue()
    {

        return $this->value;
    }

    /**
     * @param string $value
     *
     * @return ValueItem
     */
    public function setValue($value)
    {

        $this->value = $value;

        return $this;
    }

    /**
     * @return string
     */
    public function getValueClean()
    {

        return $this->valueClean;
    }

    /**
     * @param string $valueClean
     *
     * @return ValueItem
     */
    public function setValueClean($valueClean)
    {

        $this->valueClean = $valueClean;

        return $this;
    }
}
