<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Recommendation;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @package Swoox\Api\Model\Request\Recommendation
 *
 * @Serializer\XmlRoot("AddToRecommendationIndexRequest")
 */
class Request
{

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     * @Assert\NotBlank()
     * @Assert\GreaterThan(0)
     *
     * @var int
     */
    protected $id;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("keyword")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $keyword;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("weight")
     * @Serializer\Type("string")
     *
     *
     * @var int
     */
    protected $weight;

    /**
     * @return int
     */
    public function getId()
    {

        return $this->id;
    }

    /**
     * @param int $id
     *
     * @return Request
     */
    public function setId($id)
    {

        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getKeyword()
    {

        return $this->keyword;
    }

    /**
     * @param string $keyword
     *
     * @return Request
     */
    public function setKeyword($keyword)
    {

        $this->keyword = $keyword;

        return $this;
    }

    /**
     * @return int
     */
    public function getWeight()
    {

        return $this->weight;
    }

    /**
     * @param int $weight
     *
     * @return Request
     */
    public function setWeight($weight)
    {

        $this->weight = $weight;

        return $this;
    }
}
