<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Interfaces;


interface DefaultsInterface
{

    /**
     * @return array
     */
    public function getAllowedValues();

    /**
     * @return int
     */
    public function getClientid();

    /**
     * @return string
     */
    public function getFilterset();

    /**
     * @return string
     */
    public function getKeywords();

    /**
     * @return int
     */
    public function getLimit();

    /**
     * @return int
     */
    public function getOffset();

    /**
     * @return string
     */
    public function getSearch();

    /**
     * @return string
     */
    public function getSearchorder();

    /**
     * @return string
     */
    public function getSearchordertwo();

    /**
     * @return string
     */
    public function getSid();

    /**
     * @return string
     */
    public function getStatistics();

    /**
     * @return int
     */
    public function getTpl();

    /**
     * @return string
     */
    public function getTrigger();

    /**
     * @return string
     */
    public function getXfilterset();

    /**
     * @param int $clientid
     */
    public function setClientid($clientid);

    /**
     * @param string $filterset
     */
    public function setFilterset($filterset);

    /**
     * @param string $keywords
     */
    public function setKeywords($keywords);

    /**
     * @param int $limit
     */
    public function setLimit($limit);

    /**
     * @param int $offset
     */
    public function setOffset($offset);

    /**
     * @param string $search
     */
    public function setSearch($search);

    /**
     * @param string $searchorder
     */
    public function setSearchorder($searchorder);

    /**
     * @param string $searchordertwo
     */
    public function setSearchordertwo($searchordertwo);

    /**
     * @param string $sid
     */
    public function setSid($sid);

    /**
     * @param string $statistics
     */
    public function setStatistics($statistics);

    /**
     * @param int $tpl
     */
    public function setTpl($tpl);

    /**
     * @param string $trigger
     */
    public function setTrigger($trigger);

}
