<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Suggested;

use Swoox\Api\Api\Manager as ApiManager;

/**
 * Class Factory
 *
 * @package Swoox\Api\Model\Request\Search\Suggested
 */
class Factory
{

    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     * @var ApiManager
     */
    protected $apiM;


    /**
     * Factory constructor.
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     *
     * @return Types\Factory
     */
    public function types()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Types\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Request
     */
    public function requestModel()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Request();
        }

        return $this->facSetter[__FUNCTION__];
    }

}
