<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Api;

use Swoox\Api\Api\Manager;

/**
 * Class ManagerTest
 *
 * @package Tests\Swoox\Api
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Manager
     */
    private $manager;

    /**
     *
     */
    public function setUp()
    {

        $this->manager = new Manager();
    }

    /**
     *
     */
    public function testModel()
    {

        $modelManager = $this->manager->model();

        $this->assertInstanceOf('Swoox\Api\Model\Manager', $modelManager);
    }

    /**
     *
     */
    public function testValidator()
    {

        $validator = $this->manager->validator();

        $this->assertInstanceOf('Symfony\Component\Validator\Validator\ValidatorInterface', $validator);
    }
}
