<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Factory;

/**
 * Class FactoryTest
 *
 * @package Tests\Swoox\Api\Model\Request
 */
class FactoryTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Factory
     */
    private $factory;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->factory = new Factory(new ApiManager());
    }

    /**
     * testDelete
     */
    public function testDelete()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Delete\Factory', $this->factory->delete());
    }

    /**
     * testIndex
     */
    public function testIndex()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Index\Factory', $this->factory->index());
    }

    /**
     * testRecommendation
     */
    public function testRecommendation()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Recommendation\Factory', $this->factory->recommendation());
    }

    /**
     * testSearch
     */
    public function testSearch()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Factory', $this->factory->search());
    }
}
