<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Standard\Types;

use Swoox\Api\Model\Request\Search\Interfaces\TypeInterface;
use Swoox\Api\Model\Request\Search\Traits\Type;
use Symfony\Component\Validator\Constraints\Regex;

class DateTime implements TypeInterface
{

    use Type;

    /**
     * @param mixed $value
     * @param null  $key
     *
     * @return $this
     * @throws \Exception
     */
    public function setFromQuery($value, $key = null)
    {

        /**
         * DateTime validator doesn't work for our date and time format.
         */
        $constraintDate = new Regex(
            [
                'pattern' => '/\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2})?/',
                'message' => 'Invalid Date/DateTime passed!',
            ]
        );

        $message = '';
        $hasError = false;

        if (is_array($value)) {  // first off, we need an array. Bob Marley already knew to say: No array no cry

            $value[] = '0';  // super cheap, but efficient cheat to make sure the array has at least 2 entries
            $value = array_values($value);  // "clean up" array keys, making sure the array indices are numericals starting with "0"
            $value = [$value[0], $value[1]];  // and now make sure again we only have the first two left

            $errors = $this->validator->validate($value[0], $constraintDate);
            if ($errors->count() > 0) {
                $message = $errors->get(0)->getMessage();
                $hasError = true;
            }

            $errors = $this->validator->validate($value[1], $constraintDate);
            if ($errors->count() > 0) {
                $message = $errors->get(0)->getMessage();
                $hasError = true;
            }

        } else {
            $message = 'Value needs to be an array of a date range!';
            $hasError = true;
        }

        if ($hasError) {
            // there were errors during processing / validation, exception out passing the error message
            throw new \Exception($message);
        }

        $this->value = $value;

        return $this;
    }
}
