<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Standard;

use JMS\Serializer\Annotation as Serializer;


/**
 *
 * @Serializer\XmlRoot("Item")
 */
class Item
{

    /**
     * additional fields for response
     */

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentFields")
     * @Serializer\Type("array<Swoox\Api\Model\Request\Index\Swoox\NameFieldList>")
     * @Serializer\XmlList(entry="NameFieldList")
     *
     * @var \Swoox\Api\Model\Request\Index\Swoox\NameFieldList[]
     */
    protected $documentFields = array();
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentLanguage")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentLanguage;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentPrefix")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentPrefix;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentRanking")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentRanking;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentText")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentText;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentTitle")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentTitle;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentURL")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentURL;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentUniqueKey")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentUniqueKey;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("GeneratedRanking")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $generatedRanking;

    /**
     * normal fields
     */
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("HitPosition")
     * @Serializer\Type("integer")
     *
     * @var string
     */
    protected $hitPosition;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("OrderArray")
     * @Serializer\Type("array<Swoox\Api\Model\Response\Search\Standard\Sort>")
     * @Serializer\XmlList(entry="Sort")
     *
     * @var \Swoox\Api\Model\Response\Search\Standard\Sort[]
     */
    protected $orders = array();
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("percent")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $percent;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RankPosition")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $rankPosition;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Score")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $score;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Template")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $template;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TemplateAddonOne")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $templateAddonOne;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TemplateAddonThree")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $templateAddonThree;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TemplateAddonTwo")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $templateAddonTwo;

    /**
     * @param Sort $sort
     *
     * @return $this
     */
    public function addOrder(Sort $sort)
    {

        $this->orders[] = $sort;

        return $this;
    }

    /**
     * @return NameFieldList[]
     */
    public function getDocumentFields()
    {

        return $this->documentFields;
    }

    /**
     * @param string $name
     * @return bool|\Swoox\Api\Model\Request\Index\Swoox\NameFieldList
     */
    public function getDocumentFieldByName($name = "")
    {
        foreach ($this->documentFields as $key=>$field)
        {
            if ($name == $field->getName())
                return $this->documentFields[$key];

        }
        return false;
    }

    /**
     * @return string
     */
    public function getDocumentLanguage()
    {

        return $this->documentLanguage;
    }

    /**
     * @return string
     */
    public function getDocumentPrefix()
    {

        return $this->documentPrefix;
    }

    /**
     * @return string
     */
    public function getDocumentRanking()
    {

        return $this->documentRanking;
    }

    /**
     * @return string
     */
    public function getDocumentText()
    {

        return $this->documentText;
    }

    /**
     * @return string
     */
    public function getDocumentTitle()
    {

        return $this->documentTitle;
    }

    /**
     * @return string
     */
    public function getDocumentURL()
    {

        return $this->documentURL;
    }

    /**
     * @return string
     */
    public function getDocumentUniqueKey()
    {

        return $this->documentUniqueKey;
    }

    /**
     * @return string
     */
    public function getGeneratedRanking()
    {

        return $this->generatedRanking;
    }

    /**
     * @param string $generatedRanking
     *
     * @return Item
     */
    public function setGeneratedRanking($generatedRanking)
    {

        $this->generatedRanking = $generatedRanking;

        return $this;
    }

    /**
     * @return string
     */
    public function getHitPosition()
    {

        return $this->hitPosition;
    }

    /**
     * @param string $hitPosition
     *
     * @return Item
     */
    public function setHitPosition($hitPosition)
    {

        $this->hitPosition = $hitPosition;

        return $this;
    }

    /**
     * @return Sort[]
     */
    public function getOrders()
    {

        return $this->orders;
    }

    /**
     * @return string
     */
    public function getPercent()
    {

        return $this->percent;
    }

    /**
     * @param string $percent
     *
     * @return Item
     */
    public function setPercent($percent)
    {

        $this->percent = $percent;

        return $this;
    }

    /**
     * @return string
     */
    public function getRankPosition()
    {

        return $this->rankPosition;
    }

    /**
     * @param string $rankPosition
     *
     * @return Item
     */
    public function setRankPosition($rankPosition)
    {

        $this->rankPosition = $rankPosition;

        return $this;
    }

    /**
     * @return string
     */
    public function getScore()
    {

        return $this->score;
    }

    /**
     * @param string $score
     *
     * @return Item
     */
    public function setScore($score)
    {

        $this->score = $score;

        return $this;
    }

    /**
     * @return string
     */
    public function getTemplate()
    {

        return $this->template;
    }

    /**
     * @param string $template
     *
     * @return Item
     */
    public function setTemplate($template)
    {

        $this->template = $template;

        return $this;
    }

    /**
     * @return string
     */
    public function getTemplateAddonOne()
    {

        return $this->templateAddonOne;
    }

    /**
     * @param string $templateAddonOne
     *
     * @return Item
     */
    public function setTemplateAddonOne($templateAddonOne)
    {

        $this->templateAddonOne = $templateAddonOne;

        return $this;
    }

    /**
     * @return string
     */
    public function getTemplateAddonThree()
    {

        return $this->templateAddonThree;
    }

    /**
     * @param string $templateAddonThree
     *
     * @return Item
     */
    public function setTemplateAddonThree($templateAddonThree)
    {

        $this->templateAddonThree = $templateAddonThree;

        return $this;
    }

    /**
     * @return string
     */
    public function getTemplateAddonTwo()
    {

        return $this->templateAddonTwo;
    }

    /**
     * @param string $templateAddonTwo
     *
     * @return Item
     */
    public function setTemplateAddonTwo($templateAddonTwo)
    {

        $this->templateAddonTwo = $templateAddonTwo;

        return $this;
    }

}
