<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Suggested;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class FilterRangeArray
 *
 * @package Swoox\Api\Model\Response\Search\Suggested
 *
 * @Serializer\XmlRoot("FilterRangeArray")
 */
class FilterRangeArray
{

    /**
     * @Serializer\SerializedName("Filter")
     * @Serializer\Type("ArrayCollection<Swoox\Api\Model\Response\Search\Suggested\Filter>")
     * @Serializer\XmlList(inline=true, entry="Filter")
     *
     * @var Filter[]
     */
    protected $filter;


    /**
     * FilterRangeArray constructor.
     */
    public function __construct()
    {

        $this->filter = new ArrayCollection();
    }

    /**
     * @param Filter $filter
     *
     * @return FilterRangeArray
     */
    public function addFilter(Filter $filter)
    {

        if (!$this->filter->contains($filter)) {
            $this->filter->add($filter);
        }

        return $this;
    }

    /**
     * @return Filter[]
     */
    public function getFilters()
    {

        return $this->filter;
    }
}
