<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Model\Request\Index\Swoox\NameFieldList;
use Swoox\Api\Model\Request\Index\Swoox\ValueItem;

/**
 * Class NameFieldListTest
 *
 * @package Tests\Swoox\Api\Model\Request\Index\Swoox
 */
class NameFieldListTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $jsonString = '{"Meta":"meta","Name":"name","Value":"value","ValueClean":"value clean","Values":[{"Value":"one"}]}';

        $nameFieldList = new NameFieldList();

        $nameFieldList->setMeta('meta');
        $nameFieldList->setName('name');
        $nameFieldList->setValue('value');
        $nameFieldList->setValueClean('value clean');

        $valueItem = new ValueItem();
        $valueItem->setValue('one');
        $nameFieldList->setValues([$valueItem]);


        $this->assertEquals($jsonString, $this->serializer->serialize($nameFieldList, 'json'));

        $jsonString = '{"Meta":"meta","Name":"name","Value":"value","ValueClean":"value clean","Values":[{"Value":"one"},{"Value":"two"}]}';


        $valueItem = new ValueItem();
        $valueItem->setValue('two');
        $nameFieldList->addValues($valueItem);


        $this->assertEquals($jsonString, $this->serializer->serialize($nameFieldList, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        $xml = file_get_contents('Tests/data/Swoox/Api/Model/Request/Index/Swoox/namefieldlist.xml', true);

        /**
         * @var \Swoox\Api\Model\Request\Index\Swoox\NameFieldList $nameFieldList
         */
        $nameFieldList = $this->serializer->deserialize($xml, 'Swoox\Api\Model\Request\Index\Swoox\NameFieldList', 'xml');


        $this->assertEquals('meta', $nameFieldList->getMeta());
        $this->assertEquals('name', $nameFieldList->getName());
        $this->assertEquals('value', $nameFieldList->getValue());
        $this->assertEquals('value clean', $nameFieldList->getValueClean());

        $valueItems = $nameFieldList->getValues();

        $this->assertCount(2, $valueItems);
        $this->assertEquals('one', $valueItems[0]->getValue());
        $this->assertEquals('two', $valueItems[1]->getValue());
    }
}
