<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      René Stetter
 * @copyright   2017 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Swoox\Api\Entity;

/**
 * Interface EntityInterface
 *
 * An Entity which should be indexed in swoox must implement this interface
 *
 * @package Swoox\Api\Entity
 */
interface EntityInterface
{
    /**
     * Returns custom id for swoox index
     *
     * @return string
     */
    public function getSwooxId();

    /**
     * Returns unique id for swoox index
     *
     * @return string
     */
    public function getSwooxUniqueId();

    /**
     * Returns custom keyword for swoox index
     *
     * @return string
     */
    public function getSwooxKeyword();

    /**
     * Returns the swoox export type name
     *
     * @return string
     */
    public function getSwooxExportType();

    /**
     * Returns array of references to other objects
     *
     * @return array
     */
    public function getSwooxReferences();
}
