<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Interfaces;


/**
 * Interface BasicResponseModelInterface
 *
 * @package Swoox\Api\Model\Response\Search\Interfaces
 */
interface BasicResponseModelInterface
{

    /**
     * @return string
     */
    public function getKeywords();

    /**
     * @return int
     */
    public function getResultsCount();

    /**
     * @return float
     */
    public function getScriptSeconds();

    /**
     * @param string $keywords
     *
     * @return $this
     */
    public function setKeywords($keywords);

    /**
     * @param int $resultsCount
     *
     * @return $this
     */
    public function setResultsCount($resultsCount);

    /**
     * @param float $scriptSeconds
     *
     * @return $this
     */
    public function setScriptSeconds($scriptSeconds);

}
