<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Api;

use Swoox\Api\Model\Manager as ModelManager;
use Symfony\Component\Validator\Validation;

/**
 * Class Manager
 *
 * @package Swoox\Api\Api
 */
class Manager
{

    /**
     * @var array
     */
    private $factory = [];

    /**
     * @return ModelManager
     */
    public function model()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelManager($this));
    }

    /**
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    public function validator()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = Validation::createValidator());
    }
}
