<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Standard\Types;

use Swoox\Api\Model\Request\Search\Interfaces\TypeInterface;
use Swoox\ClientBundle\Entity\ProSlots;


class GeoPoint implements TypeInterface
{

    use \Swoox\Api\Model\Request\Search\Traits\Type;

    /**
     * @param $value
     *
     * @return self
     */
    public function setFromQuery($value, $key = null)
    {

        $constraint = new \Symfony\Component\Validator\Constraints\Regex([
                'pattern' => '/[-]?\d+\.\d+;[-]?\d+\.\d+;\d+km/',
                'message' => 'Invalid Geopoint format passed!',
            ]
        );

        if (is_array($value)) {
            $value = array_values($value);
            $value = $value[0];
        }

        $errors = $this->validator->validate($value, $constraint);
        if ($errors->count() > 0) {
            throw new \Exception($errors->get(0)->getMessage());
        }

        $this->value = $value;

        return $this;
    }

}
