<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Search\Filter\Types;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Search\Filter\Types\DateTime;

/**
 * Class DateTimeTest
 *
 * @package Tests\Swoox\Api\Model\Request\Search\Filter\Types
 */
class DateTimeTest extends \PHPUnit_Framework_TestCase
{

    /**
     * testSetFromQuery
     *
     * @throws \Exception
     */
    public function testSetFromQuery()
    {

        $dateTime = new DateTime(new ApiManager());

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\DateTime', $dateTime->setFromQuery(['2016-02-02T12:15', '2016-02-02T12:25']));
    }

    /**
     * testSetFromQueryNoArray
     *
     * @expectedException \Exception
     * @expectedExceptionMessage Value needs to be an array of a date range!
     */
    public function testSetFromQueryNoArray()
    {

        $dateTime = new DateTime(new ApiManager());
        $dateTime->setFromQuery('fail');
    }

    /**
     * testSetFromQueryValueOneNoDateTime
     *
     * @expectedException \Exception
     * @expectedExceptionMessage Invalid Date/DateTime passed!
     */
    public function testSetFromQueryValueOneNoDateTime()
    {

        $dateTime = new DateTime(new ApiManager());
        $dateTime->setFromQuery(['fail', '2016-02-02T12:25']);
    }

    /**
     * testSetFromQueryValueTwoNoDateTime
     *
     * @expectedException \Exception
     * @expectedExceptionMessage Invalid Date/DateTime passed!
     */
    public function testSetFromQueryValueTwoNoDateTime()
    {

        $dateTime = new DateTime(new ApiManager());
        $dateTime->setFromQuery(['2016-02-02T12:25', 'fail']);
    }
}
