<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @package Swoox\Api\Model\Request\Index\Swoox
 *
 * @Serializer\XmlRoot("AddToIndexRequest")
 */
class Request
{

    /**
     * Request constructor.
     */
    public function __construct()
    {

        $this->userData = new UserData();
    }

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("UserData")
     * @Serializer\Type("Swoox\Api\Model\Request\Index\Swoox\UserData")
     *
     * @var \Swoox\Api\Model\Request\Index\Swoox\UserData
     */
    protected $userData;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ItemsArray")
     * @Serializer\Type("array<Swoox\Api\Model\Request\Index\Swoox\Item>")
     * @Serializer\XmlList(entry="Item")
     *
     * @var Item[]
     */
    protected $items = [];

    /**
     * @param Item $item
     *
     * @return Item
     */
    public function addItem(Item $item)
    {

        $this->items[] = $item;

        return $item;
    }

    /**
     * @return Item[]
     */
    public function getItems()
    {

        return $this->items;
    }

    /**
     * @return UserData
     */
    public function getUserData()
    {

        return $this->userData;
    }
}
