<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search;

use Swoox\Api\Api\Manager as ApiManager;


class Factory
{

    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     * @var ApiManager
     */
    protected $apiM;

    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     *
     * @return Standard\Factory
     */
    public function standard()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Standard\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }


    /**
     *
     * @return Filter\Factory
     */
    public function filter()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Filter\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Standard\Factory
     */
    public function suggested()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Suggested\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

}
