<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Rules;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @package Swoox\Api\Model\Response\Rules
 *
 * @Serializer\XmlRoot("response")
 */
class Response
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("clientId")
     * @Serializer\Type("integer")
     * @Assert\NotBlank()
     * @Assert\GreaterThan(0)
     *
     * @var int
     */
    private $clientId;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("ruleName")
     * @Serializer\XmlElement(cdata=false)
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $ruleName;

    /**
     * @Serializer\SerializedName("statusCode")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $statusCode;
    
    /**
     * @Serializer\SerializedName("error")
     * @Serializer\XmlElement(cdata=false)
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $error;

    /**
     * @Serializer\SerializedName("results")
     * @Serializer\Type("array<string, string>")
     * @Serializer\XmlElement(cdata=false)
     * @Serializer\XmlMap()
     *
     * @var array
     */
    private $results;

    /**
     * @return int
     */
    public function getClientId()
    {
        return $this->clientId;
    }

    /**
     * @param int $clientId
     * @return Response
     */
    public function setClientId($clientId)
    {
        $this->clientId = $clientId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRuleName()
    {
        return $this->ruleName;
    }

    /**
     * @param string $ruleName
     * @return Response
     */
    public function setRuleName($ruleName)
    {
        $this->ruleName = $ruleName;
        return $this;
    }

    /**
     * @return int
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }

    /**
     * @param int $statusCode
     * @return Response
     */
    public function setStatusCode($statusCode)
    {
        $this->statusCode = $statusCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @param string $error
     * @return Response
     */
    public function setError($error)
    {
        $this->error = $error;
        return $this;
    }

    /**
     * @return array
     */
    public function getResults()
    {
        return $this->results;
    }

    /**
     * @param array $results
     * @return Response
     */
    public function setResults($results)
    {
        $this->results = $results;
        return $this;
    }
}
