<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

/**
 * Created by PhpStorm.
 * User: minduser
 * Date: 30/03/16
 * Time: 11:18
 */

namespace Swoox\Api\Model\Response\Search\Suggested;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class FilterItem
 *
 * @package Swoox\Api\Model\Response\Search\Suggested
 * @Serializer\XmlRoot("Item")
 */
class FilterItem
{
    /**
     * @Serializer\SerializedName("Clean")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $clean;
    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $count;
    /**
     * @Serializer\SerializedName("Data")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $data;
    /**
     * @Serializer\SerializedName("Selected")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $selected;
    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $value;

    /**
     * @return mixed
     */
    public function getClean()
    {

        return $this->clean;
    }

    /**
     * @param mixed $clean
     *
     * @return Item
     */
    public function setClean($clean)
    {

        $this->clean = $clean;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getCount()
    {

        return $this->count;
    }

    /**
     * @param mixed $count
     *
     * @return Item
     */
    public function setCount($count)
    {

        $this->count = $count;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getData()
    {

        return $this->data;
    }

    /**
     * @param mixed $data
     *
     * @return Item
     */
    public function setData($data)
    {

        $this->data = $data;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getSelected()
    {

        return $this->selected;
    }

    /**
     * @param mixed $selected
     *
     * @return Item
     */
    public function setSelected($selected)
    {

        $this->selected = $selected;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {

        return $this->value;
    }

    /**
     * @param mixed $value
     *
     * @return Item
     */
    public function setValue($value)
    {

        $this->value = $value;

        return $this;
    }
}
