<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Delete\Swoox;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Model\Request\Delete\Swoox\Item;

/**
 * Class ItemTest
 *
 * @package Tests\Swoox\Model\Request\Delete\Swoox
 */
class ItemTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     *
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     *
     */
    public function testSerialize()
    {

        $jsonString = '{"DocumentUniqueKey":"xyz"}';

        $item = new Item();
        $item->setDocumentUniqueKey('xyz');

        $json = $this->serializer->serialize($item, 'json');

        $this->assertEquals($jsonString, $json);
    }

    /**
     *
     */
    public function testDeserialize()
    {

        $xml = file_get_contents('Tests/data/Swoox/Api/Model/Request/Delete/Swoox/item.xml', true);

        /**
         * @var \Swoox\Api\Model\Request\Delete\Swoox\Item $item
         */
        $item = $this->serializer->deserialize($xml, 'Swoox\Api\Model\Request\Delete\Swoox\Item', 'xml');

        $this->assertInstanceOf('Swoox\Api\Model\Request\Delete\Swoox\Item', $item);
        $this->assertEquals('xyz', $item->getDocumentUniqueKey());
    }
}
