<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Delete\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Item
 *
 * @package Swoox\Api\Model\Request\Index\Swoox
 *
 * @Serializer\XmlRoot("Item")
 */
class Item
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentUniqueKey")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentUniqueKey;

    /**
     * @return string
     */
    public function getDocumentUniqueKey()
    {

        return $this->documentUniqueKey;
    }

    /**
     * @param string $documentUniqueKey
     *
     * @return Item
     */
    public function setDocumentUniqueKey($documentUniqueKey)
    {

        $this->documentUniqueKey = $documentUniqueKey;

        return $this;
    }
}
