<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class NameFieldList
 *
 * @package Swoox\Api\Model\Request\Index\Swoox
 *
 * @Serializer\XmlRoot("NameFieldList")
 */
class NameFieldList
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Meta")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $meta;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $name;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $value;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ValueClean")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $valueClean;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Values")
     * @Serializer\Type("array<Swoox\Api\Model\Request\Index\Swoox\ValueItem>")
     * @Serializer\XmlList(entry="ValueItem")
     *
     * @var \Swoox\Api\Model\Request\Index\Swoox\ValueItem[]
     */
    protected $values = array();

    /**
     * @return string
     */
    public function getMeta()
    {

        return $this->meta;
    }

    /**
     * @param string $meta
     *
     * @return NameFieldList
     */
    public function setMeta($meta)
    {

        $this->meta = $meta;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {

        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return NameFieldList
     */
    public function setName($name)
    {

        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getValue()
    {

        return $this->value;
    }

    /**
     * @param string $value
     *
     * @return NameFieldList
     */
    public function setValue($value)
    {

        $this->value = $value;

        return $this;
    }

    /**
     * @return string
     */
    public function getValueClean()
    {

        return $this->valueClean;
    }

    /**
     * @param string $valueClean
     *
     * @return NameFieldList
     */
    public function setValueClean($valueClean)
    {

        $this->valueClean = $valueClean;

        return $this;
    }

    /**
     * @return ValueItem[]
     */
    public function getValues()
    {

        return $this->values;
    }

    /**
     * @param ValueItem[] $values
     *
     * @return NameFieldList
     */
    public function setValues($values)
    {

        $this->values = $values;

        return $this;
    }

    /**
     * @param ValueItem $valueItem
     *
     * @return $this
     */
    public function addValues(ValueItem $valueItem)
    {

        $this->values[] = $valueItem;

        return $this;
    }
}
