<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Traits;


trait Type
{

    /**
     * @var \Swoox\Api\Api\Manager
     */
    protected $apiM;
    /**
     * @var \Swoox\ClientBundle\Entity\ProSlots
     */
    protected $slotConfig;
    /**
     * @var \Swoox\Api\Api\Manager
     */
    protected $validator;
    /**
     * @var string
     */
    protected $value;

    public function __construct(\Swoox\Api\Api\Manager $apiM)
    {

        $this->apiM = $apiM;
        $this->validator = $this->apiM->validator();
    }

    /**
     * @return \Swoox\ClientBundle\Entity\ProSlots
     */
    public function getSlotConfig()
    {

        return $this->slotConfig;
    }

    /**
     * @return string
     */
    public function getType()
    {

        return get_class($this);
    }

    /**
     * @return string
     */
    public function getValue()
    {

        return $this->value;
    }

    /**
     * @param $value
     *
     * @return self
     */
    abstract public function setFromQuery($value);

    /**
     * @param \Swoox\ClientBundle\Entity\ProSlots $slotConfig
     *
     * @return self
     */
    public function setSlotConfiguration(\Swoox\ClientBundle\Entity\ProSlots $slotConfig = null)
    {

        $this->slotConfig = $slotConfig;

        return $this;
    }

}
