<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search;

class Factory
{

    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @return Filter\Factory
     */
    public function filter()
    {

        if (!isset($this->facSetter['filter'])) {
            $this->facSetter['filter'] = new Filter\Factory();
        }

        return $this->facSetter['filter'];
    }

    /**
     *
     * @return Standard\Factory
     */
    public function standard()
    {

        if (!isset($this->facSetter['standard'])) {
            $this->facSetter['standard'] = new Standard\Factory();
        }

        return $this->facSetter['standard'];
    }

    /**
     *
     * @return Suggested\Factory
     */
    public function suggested()
    {

        if (!isset($this->facSetter['suggested'])) {
            $this->facSetter['suggested'] = new Suggested\Factory();
        }

        return $this->facSetter['suggested'];
    }
}
