<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Search\Filter\Types;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Search\Filter\Types\Factory;

/**
 * Class FactoryTest
 *
 * @package Tests\Swoox\Api\Model\Request\Search\Filter\Types
 */
class FactoryTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Factory
     */
    private $factory;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->factory = new Factory(new ApiManager());
    }

    /**
     * testError
     */
    public function testError()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Error', $this->factory->error());
    }

    /**
     * testDateTime
     */
    public function testDateTime()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\DateTime', $this->factory->dateTime());
    }

    /**
     * testDefaults
     */
    public function testDefaults()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Defaults', $this->factory->defaults());
    }

    /**
     * testFallback
     */
    public function testFallback()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Fallback', $this->factory->fallback());
    }

    /**
     * testGeoPoint
     */
    public function testGeoPoint()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\GeoPoint', $this->factory->geoPoint());
    }

    /**
     * testGeoShape
     */
    public function testGeoShape()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\GeoShape', $this->factory->geoShape());
    }

    /**
     * testMultiSelect
     */
    public function testMultiSelect()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\MultiSelect', $this->factory->multiSelect());
    }

    /**
     * testMultiValue
     */
    public function testMultiValue()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\MultiValue', $this->factory->multiValue());
    }

    /**
     * testRange
     */
    public function testRange()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Range', $this->factory->range());
    }

    /**
     * testValue
     */
    public function testValue()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Value', $this->factory->value());
    }
}
