<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model;

use Swoox\Api\Api\Manager as ApiManager;

/**
 * Class Manager
 *
 * @package Swoox\Api\Model
 */
class Manager
{

    /**
     * @var ApiManager
     */
    protected $apiM;
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * Manager constructor.
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     *
     * @return Request\Factory
     */
    public function request()
    {

        if (!isset($this->facSetter['request'])) {
            $this->facSetter['request'] = new Request\Factory($this->apiM);
        }

        return $this->facSetter['request'];
    }

    /**
     *
     * @return Response\Factory
     */
    public function response()
    {

        if (!isset($this->facSetter['response'])) {
            $this->facSetter['response'] = new Response\Factory();
        }

        return $this->facSetter['response'];
    }
}
