<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Delete\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Item
 *
 * @package Swoox\Api\Model\Response\Delete\Swoox
 *
 * @Serializer\XmlRoot("Item")
 */
class Item
{
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $message;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $status;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("uniqueid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $uniqueId;

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("version")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $version;

    /**
     * @return string
     */
    public function getMessage()
    {

        return $this->message;
    }

    /**
     * @param string $message
     *
     * @return Item
     */
    public function setMessage($message)
    {

        $this->message = $message;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {

        return $this->status;
    }

    /**
     * @param string $status
     *
     * @return Item
     */
    public function setStatus($status)
    {

        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getUniqueId()
    {

        return $this->uniqueId;
    }

    /**
     * @param string $uniqueId
     *
     * @return Item
     */
    public function setUniqueId($uniqueId)
    {

        $this->uniqueId = $uniqueId;

        return $this;
    }

    /**
     * @return string
     */
    public function getVersion()
    {

        return $this->version;
    }

    /**
     * @param string $version
     *
     * @return Item
     */
    public function setVersion($version)
    {

        $this->version = $version;

        return $this;
    }


}
