<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use JMS\Serializer\Annotation as Serializer;
use Swoox\Api\Model\Response\Search\Interfaces\FilterTypeInterface;


/**
 * Class Filter
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 *
 * @Serializer\XmlRoot("Filter")
 */
class Filter implements FilterTypeInterface
{

    /**
     * @Serializer\SerializedName("DistanceArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\DistanceArray")
     *
     * @var DistanceArray
     */
    protected $distanceArray;
    /**
     * @Serializer\SerializedName("DistanceSelection")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $distanceSelection;
    /**
     * @Serializer\SerializedName("Selected")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterSelected")
     *
     * @var ValueArray
     */
    protected $filterSelected;
    /**
     * @Serializer\SerializedName("MaxValue")
     * @Serializer\Type("string")
     *
     * @var double
     */
    protected $maxValue;
    /**
     * @Serializer\SerializedName("MinValue")
     * @Serializer\Type("string")
     *
     * @var double
     */
    protected $minValue;
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $name;
    /**
     * @Serializer\SerializedName("Order")
     * @Serializer\Type("integer")
     *
     * @var string
     */
    protected $order;
    /**
     * @Serializer\SerializedName("Slot")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $slot;
    /**
     * @Serializer\SerializedName("SlotClean")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $slotClean;
    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $value;
    /**
     * @Serializer\SerializedName("ValueArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\ValueArray")
     *
     * @var ValueArray
     */
    protected $valueArray;

    /**
     * @return DistanceArray
     */
    public function getDistanceArray()
    {

        return $this->distanceArray;
    }

    /**
     * @param DistanceArray $distanceArray
     *
     * @return Filter
     */
    public function setDistanceArray($distanceArray)
    {

        $this->distanceArray = $distanceArray;

        return $this;
    }

    /**
     * @return string
     */
    public function getDistanceSelection()
    {

        return $this->distanceSelection;
    }

    /**
     * @param string $distanceSelection
     *
     * @return Filter
     */
    public function setDistanceSelection($distanceSelection)
    {

        $this->distanceSelection = $distanceSelection;

        return $this;
    }

    /**
     * @return ValueArray
     */
    public function getFilterSelected()
    {

        return $this->filterSelected;
    }

    /**
     * @param FilterSelected $filterSelected
     *
     * @return Filter
     */
    public function setFilterSelected($filterSelected)
    {

        $this->filterSelected = $filterSelected;

        return $this;
    }

    /**
     * @return float
     */
    public function getMaxValue()
    {

        return $this->maxValue;
    }

    /**
     * @param float $maxValue
     *
     * @return Filter
     */
    public function setMaxValue($maxValue)
    {

        $this->maxValue = $maxValue;

        return $this;
    }

    /**
     * @return float
     */
    public function getMinValue()
    {

        return $this->minValue;
    }

    /**
     * @param float $minValue
     *
     * @return Filter
     */
    public function setMinValue($minValue)
    {

        $this->minValue = $minValue;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {

        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Filter
     */
    public function setName($name)
    {

        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrder()
    {

        return $this->order;
    }

    /**
     * @param string $order
     *
     * @return Filter
     */
    public function setOrder($order)
    {

        $this->order = $order;

        return $this;
    }

    /**
     * @return int
     */
    public function getSlot()
    {

        return $this->slot;
    }

    /**
     * @param int $slot
     *
     * @return Filter
     */
    public function setSlot($slot)
    {

        $this->slot = $slot;

        return $this;
    }

    /**
     * @return string
     */
    public function getSlotClean()
    {

        return $this->slotClean;
    }

    /**
     * @param string $slotClean
     *
     * @return Filter
     */
    public function setSlotClean($slotClean)
    {

        $this->slotClean = $slotClean;

        return $this;
    }

    /**
     * @return string
     */
    public function getValue()
    {

        return $this->value;
    }

    /**
     * @param string $value
     *
     * @return Filter
     */
    public function setValue($value)
    {

        $this->value = $value;

        return $this;
    }

    /**
     * @return ValueArray
     */
    public function getValueArray()
    {

        return $this->valueArray;
    }

    /**
     * @param ValueArray $valueArray
     *
     * @return Filter
     */
    public function setValueArray($valueArray)
    {

        $this->valueArray = $valueArray;

        return $this;
    }


}
